clc
clear all
close all
set(0,'defaultTextInterpreter','latex');          % serve a settare i grafici nei plot
set(0,'defaultAxesFontSize',20);
set(0,'defaultAxesFontName','TimesNewRoman');

%% Costanti fisiche
T=293;          % Temperatura assoluta [K]
T0=273;         % Temperatura assoluta rif. [K]
mu=1.81e-5;     % viscosit` dinamica dell'aria a 0 C [Pas]
R=287.053;      % Costante dell'aria [J/Kg/K]
Pa=1e5;         % Pressione ambiente a 273 K [Pa]
Ps=5.1e5;
b_c=0.5283;

Kt=sqrt(T/T0);
rho=Pa/(R*T);   % Densità dell'aria in condizioni normali [kg/m^3]
psi=0.6855/sqrt(R*T);
cost=1/(24*mu*R*T);
dt=1e-7;        % parametro per risolvere con Eulero esplicito
ck=60000/rho;   % per passare da l/min a kg/s

%% Geometria pattino
n_fori=4;       % numero di fori del pattino
dp=1.05e-3;        % diametro del foro di ingresso del pattino 
hg=54e-6;       % profondità media ragnatura
wg=0.16e-3;      % larghezza ragnatura
L=60e-3;
B=30e-3;
l=45e-3;
b=20e-3;
lx=(L-l)/2;
ly=(B-b)/2;
coeff=1;
A=L*B*coeff;            % Aumentando coeff gira più veloce (equivale ad aumentare il passo di tempo)
Vg=1/2*wg*hg*2*(l+b);     % volume ragnatura

% IMPOSTARE   "d_ratio" e "h_des" messi nel "Mod_0_project"
dn=0.75e-3;                      % diametro dell'ugello
d_ratio=dn/dp;
h_des=20.1;

%% parametri della valvola
dm=6e-3;                            % diametro membrana metallica m

% mettere i valori ottenuti dal Modello "0" di progetto
xn=     -2.2739e-06;
km=      1.5984e+05;


d_con=5e-3;                         % diametro dei condotti interni al pattino
V_valvola=(6e-3-3.75e-3)^2*pi/4*3.9e-3+(1.875e-3)^2*pi/4*(9)*1e-3;         % Volume della valvola
V_pat_pieno=B*L*12e-3;
V_pat_vuoto=20902.613e-9;  %calcolato con inventor
V_pattino=V_pat_pieno-V_pat_vuoto;   % volume dei condotti interni al pattino
V_cavo=pi*(2e-3)^2/4*62e-3;         % volume del tubo tra valvola e pattino
V1=V_valvola+V_pattino+V_cavo;         % volume a monte del pattino
S_eqv=(l*b+L*B+0.5*(L*b+B*l))/3;        % superficie equivalente su cui insiste la Fp considerando una distribuz. di pressione a tronco di piramide

%% Vettore delle Variabili Temporali
%Reynolds Conduttanze 
   RRe1t=[];
   RRe2t=[];
   Cda1t=[];
   Cda2t=[];
   Cs1t=[];
   Cs2t=[];
   %Pressioni
   P1t=[];
   P2t=[];
   P0t=[];
% Caratteristiche pattino + valvola 
   H0t=[];
   H_dott=[];
   Xvt=[];
   G1t=[];
   G2t=[];
   G3t=[];
   Fmt=[];
   time=[];
   FFextt=[];

%% Inizializzazione pressioni, Reynolds
p1=Ps; % [Pa]
p2=Ps;
p0=Ps;
Re1=0;
Re2=0;

%% Punto iniziale per trovare le CONDIZIONI INIZIALI

h0=4*1e-6;
V0=h0*l*b;      % volume del meato
V2=V0+Vg;       % volume tot. = volume meato + volume ragnatura

Fp0=0;
g30=0;
err_Fp=10;
err_G=10;
x_bypass=13;   %    [um]
tic
j=0;
toll=1e-6;
while (abs(err_Fp)>toll || abs(err_G)>toll)
j=j+1;

% Calcolo la distanza ugello-membrana
x=xn+(p1-Pa)*pi*dm^2/4/km;

% Verifico se sono in condizioni di x_bypass o meno
if x<x_bypass*1e-6
   x=x_bypass*1e-6;
end

% Calcolo la conduttanza dell'ugello della valvola (considero la sezione ANULARE)
cda1=1.05*(1-0.3*exp(-0.005*Re1));
C1=cda1*(pi*x*dn)*Kt*psi;      % conduttanza dell'ugello della valvola con sezione ANULARE

% Calcolo la portata dell'ugello della valvola g1
[g1]=FORO(C1,Ps,p1);        % portata attraverso l'ugello della valvola calcolata con la function FORO 
g1=g1*Kt;
Re1=abs(g1)/(pi*mu*dn);

% Calcolo la conduttanza del foro del pattino (considero la sezione ANULARE)
cda2=1.05*(1-0.3*exp(-0.005*Re2));
C2=cda2*(pi*h0*dp+wg*hg)*Kt*psi;   % conduttanza di un foro del pattino
[g2]=FORO(C2,p1,p2);             % portata attraverso un foro del pattino
g2=g2*Kt;
heq=(pi*h0*dp+hg*wg)/(pi*dp);
Re2=abs(g2)*h0/(pi*dp*mu*heq);

% Portate in uscita dal pattino
gx=cost*(h0)^3*((p0^2-Pa^2)/lx)*b;
gy=cost*(h0)^3*((p0^2-Pa^2)/ly)*l;
g3=2*(gx+gy);  

% Calcolo le pressioni p1, p0 e p2
p1=p1+(g1-g2*n_fori)*dt*R*T/V1;       % applico Eulero esplicito in avanti
p0=p0+(g2*n_fori-g3)*dt*R*T/V2;       % applico Eulero esplicito in avanti

hum=h0*1e6;
af=0.14;
bf=5;
f=1-af^(bf/hum);        % f=p0/p2;
p2=(1/f)*(p0-Pa)+Pa;   % formula inversa per trovare p2

% Calcolo la forza di pressione Fp dovuta al meato
Fp=S_eqv*(p0-Pa);

% calcolo gli errori per uscire dal while
err_Fp=(Fp-Fp0)/Fp;
err_G=(g3-g30)/g3;
            
Fp0=Fp;
g30=g3;
end
    toc
%% Modello con forza in ingresso a gradino
i=0;
contatore=0;
F_EXT=[Fp:-20:400];

for i=1:length(F_EXT)

    g=9.806;
    h0_dot=0;   % condizione iniziale di velocità --> mi serve per Eulero esplicito in avanti
    err_Fp=10;
    err_G=10;
    err_h=10;

    F_ext=F_EXT(i);
    M(i)=F_ext/g;          % massa supportata dal pattino
    
    tic
% while (abs(err_Fp)>toll || abs(err_G)>toll)
    while (abs(err_Fp)>toll || abs(err_h)>toll)


j=j+1;
contatore=contatore+1;

% Calcolo distanza ugello-membrana
x=xn+(p1-Pa)*pi*dm^2/4/km;

%Caso bypass
if x<x_bypass*1e-6
   x=x_bypass*1e-6;
end

% Conduttanza ugello valvola (si una la sezione anulare)
cda1=1.05*(1-0.3*exp(-0.005*Re1));
C1=cda1*(pi*x*dn)*Kt*psi;    %conduttanza foro valvola con area anulare

%Calcolo portata ugello valvola
[g1]=FORO(C1,Ps,p1);      %portata attraverso l'ugello della valvola   (kg/s)
Re1=abs(g1)/(pi*mu*dn);

%Conduttanza foro pattino (si una la sezione anulare)
cda2=1.05*(1-0.3*exp(-0.005*Re2));
C2=cda2*(pi*h0*dp+wg*hg)*Kt*psi;   %conduttanza di un foro del pattino
[g2]=FORO(C2,p1,p2);             %portata attraverso un foro del pattino    (kg/s)
heq=(pi*h0*dp+hg*wg)/(pi*dp);
Re2=abs(g2)*h0/(pi*dp*mu*heq);

%Portate uscita meato
gx=cost*(h0)^3*((p0^2-Pa^2)/lx)*b;
gy=cost*(h0)^3*((p0^2-Pa^2)/ly)*l;
g3=2*(gx+gy);

%Calcolo forza e nuovo meato di equilibrio
Fp=S_eqv*(p0-Pa);
h1_dot=h0_dot+dt/M(i)*(Fp-F_ext);       % Eulero esplicito in avanti
h1=h0+h0_dot*dt;                     % Eulero esplicito in avanti

%Calcolo Pressioni
V2=h0*l*b+Vg;
p1=p1+(g1-g2*n_fori)*dt*R*T/V1; % pattino attivo
p0=p0+((g2*n_fori-g3)-h0_dot*A*p0/(R*T))*dt*R*T/V2;

hum=h0*1e6;
af=0.14;
bf=5;
f=1-af^(bf/hum);        % f=p0/p2;
p2=(1/f)*(p0-Pa)+Pa;   % formula inversa per trovare p2

% Calcolo gli errori per uscire dal while
err_Fp=(Fp-F_ext)/F_ext;
err_G=(g3-g30)/g3;
err_h=(h1-h0)/h0;


Fp0=Fp; 
g30=g3;
h0=h1;
h0_dot=h1_dot;
%% VARIABILI TEMPORALI (salvate ogni 2000 punti)
punti=2000;
if contatore==punti
% %Reynolds Conduttanze 
%    RRe1t=[RRe1t Re1];
%    RRe2t=[RRe2t Re2];
%    Cda1t=[Cda1t cda1];
%    Cda2t=[Cda2t cda2];
%    Cs1t=[Cs1t C1];
%    Cs2t=[Cs2t C2];
%  %Pressioni
%    P1t=[P1t p1];
%    P2t=[P2t p2];
%    P0t=[P0t p0];
%Caratteristiche pattino + valvola 
   H0t=[H0t h0]; %(m)
   H_dott=[H_dott h0_dot]; %(m/s)
   Xvt=[Xvt x];
   G1t=[G1t g1*ck];
   G2t=[G2t g2*n_fori*ck];
   G3t=[G3t g3*ck];
   Fmt=[Fmt Fp];
   time=[time dt*j];
   FFextt=[FFextt F_ext];
   
   contatore=0;
end


end

% toc
%% VARIABILI CORRISPONDENTI AI PUNTI DI EQUILIBRIO
%    %Reynolds Conduttanze 
%    RRe1(i)=Re1;
%    RRe2(i)=Re2;
%    Cda1(i)=cda1;
%    Cda2(i)=cda2;
%    Cs1(i)=C1;
%    Cs2(i)=C2;
% 
%    %Pressioni
%    P1(i)=p1;
%    P2(i)=p2;
%    P0(i)=p0;

%Caratteristiche pattino + valvola 
   H0(i)=h0*1e6;
   H_dot(i)=h0_dot;
   Xv(i)=x;
   G1(i)=g1*ck;
   G2(i)=g2*n_fori*ck;
   G3(i)=g3*ck;
   Fm(i)=Fp;

%%  DEFINIZIONE VARIABILI DINAMICHE
% %Reynolds Conduttanze 
%    RRe1d=[Re1];
%    RRe2d=[Re2];
%    Cda1d=[cda1];
%    Cda2d=[cda2];
%    Cs1d=[C1];
%    Cs2d=[C2];
%  %Pressioni
%    P1d=[p1];
%    P2d=[p2];
%    P0d=[p0];
%Caratteristiche pattino + valvola 
%    H0d=[h0*1e6]; %(um)
%    H_dotd=[h0_dotd*1e6]; %(um/s)
%    Xvd=[x];
%    G1d=[g1*ck];
%    G2d=[g2*n_fori*ck];
%    G3d=[g3*ck];
%    Fmd=[Fp];
%    timed=[dt*j];
%    FFextd=[F_ext];
%% 	ECCITAZIONE SINUSOIDALE
%BISOGNA ADATTARE IL DT ALLA DINAMICA!
    F0_dyn=Fp;
    F0=F0_dyn;
    dF=Fp*0.001;
    Frequenze=[5 10 15 20 25 30]; %(Hz)    % Vettore delle frequenze
    n_periods=10;                 % Durata simulazione dinamica

    t=0;                    %Temporelativo all'eccitazione armonica
    
   for indf=1:length(Frequenze)
        freq=Frequenze(indf);
        n_samples=n_periods/freq/dt;                % numero di campioni da prendere
        contatore_dyn=0;
for ind_dyn=1:n_samples
        t=t+dt;
        j=j+1;
        contatore_dyn=contatore_dyn+1;
        Fext=F0+dF*sin(2*pi*freq*t);

%Calcolo distanza ugello-membrana
x=xn+(p1-Pa)*pi*dm^2/4/km;
%Caso bypass
if x<x_bypass*1e-6
   x=x_bypass*1e-6;
end

%Conduttanza ugello valvola (si una la sezione anulare)
cda1=1.05*(1-0.3*exp(-0.005*Re1));
C1=cda1*(pi*x*dn)*psi*Kt;                 % conduttanza foro valvola con area anulare

%Calcolo portata ugello valvola
[g1]=FORO(C1,Ps,p1);                   % portata attraverso l'ugello della valvola
Re1=abs(g1)/(pi*mu*dn);

%Conduttanza foro pattino (si una la sezione anulare)
cda2=1.05*(1-0.3*exp(-0.005*Re2));
C2=cda2*(pi*h0*dp+wg*hg)*psi*Kt;              % conduttanza di un foro del pattino
[g2]=FORO(C2,p1,p2);                     % portata attraverso un foro del pattino

heq=(pi*h0*dp+hg*wg)/(pi*dp);
Re2=abs(g2)*h0/(pi*dp*mu*heq);

%Portate uscita meato
gx=cost*(h0)^3*((p0^2-Pa^2)/lx)*b;
gy=cost*(h0)^3*((p0^2-Pa^2)/ly)*l;
g3=2*(gx+gy);

%Calcolo forza e nuovo meato di equilibrio
Fp=(l*b+L*B+0.5*(L*b+B*l))*(p0-Pa)/3;
h1_dot=h0_dot+dt/M(i)*(Fp-Fext);
h1=h0+h0_dot*dt;

%Calcolo Pressioni
V2=h0*l*b+Vg;
p1=p1+(g1-g2*n_fori)*dt*R*T/V1;            % pattino attivo
p0=p0+((g2*n_fori-g3)-h0_dot*A*p0/(R*T))*dt*R*T/V2;

hum=h0*1e6;
af=0.14;
bf=5;
f=1-af^(bf/hum);        % f=p0/p2;
p2=(1/f)*(p0-Pa)+Pa;   % formula inversa per trovare p2
%Aggiornamento meato e velolcità
    h0=h1;
    h0_dot=h1_dot;
    
%% VARIABILI TEMPORALI PER IL CALCOLO DI K(w) E C(w)(salvate ogni 2000 punti)
if contatore_dyn==punti
% %Reynolds Conduttanze 
%    RRe1t=[RRe1t Re1];
%    RRe2t=[RRe2t Re2];
%    Cda1t=[Cda1t cda1];
%    Cda2t=[Cda2t cda2];
%    Cs1t=[Cs1t C1];
%    Cs2t=[Cs2t C2];
%  %Pressioni
%    P1t=[P1t p1];
%    P2t=[P2t p2];
%    P0t=[P0t p0];
%Caratteristiche pattino + valvola 
   H0t=[H0t h0]; %(m)
   H_dott=[H_dott h0_dot]; %(m/s)
   Xvt=[Xvt x];
   G1t=[G1t g1*ck];
   G2t=[G2t g2*n_fori*ck];
   G3t=[G3t g3*ck];
   Fmt=[Fmt Fp];
   time=[time dt*j];
   FFextt=[FFextt F_ext];
%       FFextt=[FFextt Fext];se voglio anche la sinusoide


   contatore_dyn=0;
end

end
   
% Parto dall'ultimo punto e prendo n_periods-2
tf=time(end);
ind_cut=(time>=time(end)-(n_periods-2)/freq);   % indici degli ultimi n_periods-2
                force_cut=Fmt(ind_cut);        % Valori di forza degli ultimi n_periods-2
                time_cut=time(ind_cut);          % Valori di tempo degli ultimi n_periods-2
                airgap_cut=H0t(ind_cut);       % Valori di meato degli ultimi n_periods-2

%Costruisco lo spettro dei segnali per calcolare modulo e fase alla frequenza sincrona               
N=floor(length(time_cut));
fs=1/dt/punti; %Il salvataggio non avviene alla stessa frequenza della simulazione
df=fs/N; %frequency resolution
%Contenuti in frequenza normalizzati
Pfn=fft(force_cut-mean(force_cut))/N; %Spettro Forza normalizzato
Phn=fft(airgap_cut-mean(airgap_cut))/N; %Spettro Meato normalizzato
%Contenuti in frequenza sigle-side
f_oneside=[0:floor(N/2)]*df;
Pfn_single=2*Pfn(1:floor(N/2)+1); %La seconda parte è rindondante
Phn_single=2*Phn(1:floor(N/2)+1);
%Ricerca indice picco massimo
[picco ind_p]=max(abs(Pfn_single));
f_peak(indf,i)=f_oneside(ind_p);%indici invertici per il plot
%Ampiezze
deltaF=abs(Pfn_single(ind_p));
deltah=abs(Phn_single(ind_p));
% Amplitude(i,indf)=deltah*1e6/deltaF;
Amplitude(i,indf)=-deltaF/deltah;

%Fasi
teta_F=angle(Pfn_single(ind_p));
teta_h=angle(Phn_single(ind_p));
% fi(i,indf)=teta_h-teta_F;      % (rad)
fi(i,indf)=teta_F-teta_h;      % (rad)

%Calcolo rigidezza e smorzamento
k_dyn(i,indf)=Amplitude(i,indf)*cos(fi(i,indf))+M(i)*(2*pi*f_peak(indf,i))^2         % (N/m)
% k_dyn(i,indf)=Amplitude(i,indf)*cos(fi(i,indf))         % (N/m)
cw_dyn(i,indf)=Amplitude(i,indf)*sin(fi(i,indf));
damping(i,indf)=cw_dyn(i,indf)./((2*pi*f_peak(indf,i)))            % (Ns/m)


   end
   toc
end
% toc
%%
figure
plot(time,Fmt,'b','linewidth',2),grid on, hold on,
plot(time,FFextt,'r','linewidth',2),grid on, hold on,
xlabel(' Time  $(s) $'),
ylabel(' Force  $ \quad F$ $(N)$ '),

figure
plot(time,H0t*1e6,'linewidth',2),grid on, hold on,
xlabel(' Time  $(s) $'),
ylabel(' Air Gap  $ \quad h$ $(\mu m)$ '),
%%

h_min=min(H0);
h_max=max(H0);
F_min=min(Fm);
F_max=max(Fm);


%% CAPACITA' DI CARICO
figure 
plot(H0*1e6,Fm,'b','linewidth',2),grid on, hold on,
xlabel(' Air \quad gap $\quad h$ $(\mu m) $'),
ylabel(' Force  $ \quad F$ $(N)$ '),
grid on, zoom on
xlim([h_min h_max])

%% CONSUMO D'ARIA
figure 
plot(H0,G3,'b','linewidth',2),grid on, hold on,
xlabel(' Air \quad gap $\quad h$ $(\mu m) $'),
ylabel(' Flow \quad Rate  \quad $Q$ $(\frac{l}{min} \quad ANR \quad 20^{\circ}$)'),
grid on, zoom on
xlim([h_min h_max])

%% RIGIDEZZA E SMORZAMENTO
figure 
plot(f_peak,k_dyn','linewidth',2),grid on, hold on,
xlabel('  Frequency $ \quad $  f   $ \quad (Hz) $'),
ylabel(' Stiffness  $\quad k $ ($ \frac{N}{ \mu m} $)'),
grid on, zoom on

figure 
plot(f_peak,damping','linewidth',2),grid on, hold on,
xlabel('  Frequency $ \quad $  f   $ \quad (Hz) $'),
ylabel(' Damping  $\quad c \quad $ ($ \frac{N \cdot s}{ \mu m} $)'),
grid on, zoom on

figure 
plot(H0,k_dyn,'linewidth',2),grid on, hold on,
xlabel(' Air \quad gap $\quad h$ $(\mu m) $'),
ylabel(' Stiffness  $\quad k $ ($ \frac{N}{ \mu m} $)'),
grid on, zoom on

figure 
plot(H0,damping,'linewidth',2),grid on, hold on,
xlabel(' Air \quad gap $\quad h$ $(\mu m) $'),
ylabel(' Damping  $\quad c \quad $ ($ \frac{N \cdot s}{ \mu m} $)'),
grid on, zoom on

%% SALVATAGGIO PARAMETRIZZATO
stringa_f=['Frequenze_Ps' num2str(round(abs(Ps*1e-5))) '=Frequenze;'];
stringa_fc=['f_Ps' num2str(round(abs(Ps*1e-5))) '=f_peak;'];
stringa_H0=['H0_Ps' num2str(round(abs(Ps*1e-5))) '=H0;'];

stringa_Mag=['Mag_Ps' num2str(round(abs(Ps*1e-5))) '=Amplitude;'];
stringa_phi=['phase_Ps' num2str(round(abs(Ps*1e-5))) '=fi;'];

stringa_k=['k_NL_Ps' num2str(round(abs(Ps*1e-5))) '=k_dyn;'];
stringa_c=['c_NL_Ps' num2str(round(abs(Ps*1e-5))) '=damping;'];

stringa_dynNL=['save Simul_Dyn_NL_Ps' num2str(round(abs(Ps*1e-5))) ' Frequenze_Ps' num2str(round(abs(Ps*1e-5)))  ' f_Ps' num2str(round(abs(Ps*1e-5)))  ' H0_Ps' num2str(round(abs(Ps*1e-5))) ' Mag_Ps' num2str(round(abs(Ps*1e-5))) ' phase_Ps' num2str(round(abs(Ps*1e-5))) ' k_NL_Ps' num2str(round(abs(Ps*1e-5))) ' c_NL_Ps' num2str(round(abs(Ps*1e-5)))];

eval(stringa_f)
eval(stringa_fc)
eval(stringa_H0)
eval(stringa_Mag)
eval(stringa_phi)
eval(stringa_k)
eval(stringa_c)

eval(stringa_dynNL) 
 